/**
 * Unofficial LabJack example that combines the Serial_number_and_4_AINs example
 * as well as the Processing Button example that allows for control of
 * the DAC0.  If you add a jumper wire between DAC0 and AIN0 the voltage
 * that appears on the DAC0 line will be read back by the device.
 */

import java.text.DecimalFormat;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.labjack.LJM;
import com.labjack.LJMException;


/**
 * Code from the Button Example. 
 * 
 * Click on one of the colored squares in the 
 * center of the image to change the color of 
 * the background. 
 */
int rectX, rectY;      // Position of square button
int circleX, circleY;  // Position of circle button
int rectSize = 90;     // Diameter of rect
int circleSize = 93;   // Diameter of circle
color rectColor, circleColor, baseColor;
color rectHighlight, circleHighlight;
color currentColor;
boolean rectOver = false;
boolean circleOver = false;

/* Define variables for the device handle */
IntByReference handleRef = new IntByReference(0);
int handle = 0;

void setup(){
  /* Code from the Serial_number_and_4_AINs example */
  size(1024, 689);
  textSize(32);
  fill(100);
  frameRate(30);
  
  /* Code from the Button Example */
  //size(640, 360);
  rectColor = color(0);
  rectHighlight = color(51);
  circleColor = color(255);
  circleHighlight = color(204);
  baseColor = color(102);
  currentColor = baseColor;
  circleX = width/2+circleSize/2+10;
  circleY = height/2;
  rectX = width/2-rectSize-10;
  rectY = height/2-rectSize/2;
  ellipseMode(CENTER);
}
void draw(){
  clear();
  
  /* Code from the Button example */
  update(mouseX, mouseY);
  //background(currentColor);
  
  if (rectOver) {
    fill(rectHighlight);
  } else {
    fill(rectColor);
  }
  stroke(255);
  rect(rectX, rectY, rectSize, rectSize);
  
  if (circleOver) {
    fill(circleHighlight);
  } else {
    fill(circleColor);
  }
  stroke(0);
  ellipse(circleX, circleY, circleSize, circleSize);
  
  /* Code from the Serial_number_and_4_AINs example */
  try {
      //Open first found LabJack
      LJM.openS("ANY", "ANY", "ANY", handleRef);
      handle = handleRef.getValue();
      
      //Call eReadName to read the serial number from the LabJack.
      String name = "SERIAL_NUMBER";
      DoubleByReference valueRef = new DoubleByReference(0);
      LJM.eReadName(handle, name, valueRef);
      text(("    " + name + " = " + new DecimalFormat("#.#").format( valueRef.getValue() )), 50, 50);
      
      name = "AIN0";
      LJM.eReadName(handle, name, valueRef);
      text((name + ": " + new DecimalFormat("#.######").format( valueRef.getValue() )), 150, 150);
      
      name = "AIN1";
      LJM.eReadName(handle, name, valueRef);
      text((name + ": " + new DecimalFormat("#.######").format( valueRef.getValue() )), 150, 200);
      
      name = "AIN2";
      LJM.eReadName(handle, name, valueRef);
      text((name + ": " + new DecimalFormat("#.######").format( valueRef.getValue() )), 150, 250);
      
      name = "AIN3";
      LJM.eReadName(handle, name, valueRef);
      text((name + ": " + new DecimalFormat("#.######").format( valueRef.getValue() )), 150, 300);
      
      text(millis()/1000, 150, 350);
  }
  catch (LJMException le) {
      le.printStackTrace();
  }
}

void update(int x, int y) {
  if ( overCircle(circleX, circleY, circleSize) ) {
    circleOver = true;
    rectOver = false;
  } else if ( overRect(rectX, rectY, rectSize, rectSize) ) {
    rectOver = true;
    circleOver = false;
  } else {
    circleOver = rectOver = false;
  }
}

void mousePressed() {
  if (circleOver) {
    try {
      LJM.eWriteName(handle, "DAC0", 0.0);
    }
    catch (LJMException le) {
      le.printStackTrace();
    }
  }
  if (rectOver) {
    try {
      LJM.eWriteName(handle, "DAC0", 3.14);
    }
    catch (LJMException le) {
      le.printStackTrace();
    }
  }
}

boolean overRect(int x, int y, int width, int height)  {
  if (mouseX >= x && mouseX <= x+width && 
      mouseY >= y && mouseY <= y+height) {
    return true;
  } else {
    return false;
  }
}

boolean overCircle(int x, int y, int diameter) {
  float disX = x - mouseX;
  float disY = y - mouseY;
  if (sqrt(sq(disX) + sq(disY)) < diameter/2 ) {
    return true;
  } else {
    return false;
  }
}