import java.text.DecimalFormat;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.labjack.LJM;
import com.labjack.LJMException;
void setup(){
  size(1024, 689);
  textSize(32);
  fill(100);
  frameRate(30);
}
void draw(){
clear();
  try {
      IntByReference handleRef = new IntByReference(0);
      int handle = 0;
      //Open first found LabJack
      LJM.openS("ANY", "ANY", "ANY", handleRef);
      handle = handleRef.getValue();
      //Call eReadName to read the serial number from the LabJack.
      String name = "SERIAL_NUMBER";
      DoubleByReference valueRef = new DoubleByReference(0);
      LJM.eReadName(handle, name, valueRef);
      text(("    " + name + " = " + new DecimalFormat("#.#").format( valueRef.getValue() )), 50, 50);
      
      name = "AIN0";
      LJM.eReadName(handle, name, valueRef);
      text((name + ": " + new DecimalFormat("#.######").format( valueRef.getValue() )), 150, 150);
      
      name = "AIN1";
      LJM.eReadName(handle, name, valueRef);
      text((name + ": " + new DecimalFormat("#.######").format( valueRef.getValue() )), 150, 200);
      
      name = "AIN2";
      LJM.eReadName(handle, name, valueRef);
      text((name + ": " + new DecimalFormat("#.######").format( valueRef.getValue() )), 150, 250);
      
      name = "AIN3";
      LJM.eReadName(handle, name, valueRef);
      text((name + ": " + new DecimalFormat("#.######").format( valueRef.getValue() )), 150, 300);
      
      text(millis()/1000, 150, 350);
  }
  catch (LJMException le) {
      le.printStackTrace();
  }
}